/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.property.VWStepGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.VWStepRoutingPanel;
import filenet.vw.toolkit.runtime.property.VWStepRulePanel;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class VWBaseStepPropPanel
extends JPanel
implements ChangeListener,
ItemSelectable,
ItemListener,
IVWPropertyChangeListener {
    VWTrkDataModel m_trackerDataModel = null;
    VWStepPropPanel m_stepPropPanel;
    protected Frame m_parentFrame = null;
    protected VWStepDefinition m_stepDefinition = null;
    protected boolean m_bStepView = true;
    protected VWTrkParticipant m_selectedParticipant = null;
    protected String m_instructions = null;
    protected Vector m_tabs = null;
    protected JTabbedPane m_stepTabbedPane = null;
    protected VWStepGeneralPanel m_generalPanel = null;
    protected VWStepRoutingPanel m_routingPanel = null;
    protected VWStepRulePanel m_rulesPanel = null;
    private VWStepNParticipantRenderer m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
    protected boolean m_bLayoutInitialized = false;
    protected JTextArea m_instructionsUI = null;
    protected VWToolbarBorder m_instructionBorder = null;
    private int m_updatingCount = 0;
    private Object m_countSync = new Object();
    private boolean m_rulesEnabled = false;

    protected abstract void createTabs();

    public abstract void initialize();

    protected abstract void initData();

    protected abstract void setupLayout();

    abstract void updateDisplay();

    protected VWToolbarBorder setupTextAreaBorder(String title, JTextArea textArea) {
        VWToolbarBorder textAreaBorder = new VWToolbarBorder(title, 0);
        JPanel panel = textAreaBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        textArea.setColumns(5);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        JScrollPane dirScrollPane = new JScrollPane(textArea);
        dirScrollPane.setPreferredSize(new Dimension(10, 50));
        panel.add((Component)dirScrollPane, "Center");
        return textAreaBorder;
    }

    protected void setupTabbedPane() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        this.m_stepTabbedPane = new JTabbedPane();
        this.m_stepTabbedPane.addChangeListener(this);
    }

    protected void setupInstructionBorder(String title) {
        if (this.m_instructionsUI == null) {
            this.m_instructionsUI = new JTextArea();
        }
        this.m_instructionBorder = this.setupTextAreaBorder(title, this.m_instructionsUI);
    }

    protected void updatePanelDisplay() {
        if (!this.m_bLayoutInitialized) {
            this.setupLayout();
        } else {
            this.updateDisplay();
        }
    }

    protected void refreshTabs() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        Object obj = null;
        for (int i = 0; i < this.m_tabs.size(); ++i) {
            obj = this.m_tabs.elementAt(i);
            if (obj == null || !(obj instanceof VWStepPropTabPanel)) continue;
            ((VWStepPropTabPanel)obj).refresh();
        }
        this.updateSelectedTabNow();
    }

    protected abstract void updateDataWithSelectedStep();

    public abstract void propertyChange(VWPropertyChangeEvent var1);

    public VWBaseStepPropPanel(VWStepPropPanel stepPropPanel, Frame parentFrame) {
        this.m_stepPropPanel = stepPropPanel;
        this.m_parentFrame = parentFrame;
        if (stepPropPanel != null) {
            this.m_trackerDataModel = stepPropPanel.getDataModel();
        }
        this.getRulesSystemFlag();
        this.createTabs();
        if (!this.m_bLayoutInitialized) {
            this.setupLayout();
        }
    }

    protected boolean isTrackerDataInitialized() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.isTrackerDataInitialized();
        }
        return false;
    }

    protected void setDataUpdated(boolean bUpdated) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.setDataUpdated(bUpdated);
        }
    }

    protected boolean isDataUpdated() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.isDataUpdated();
        }
        return true;
    }

    protected boolean isDisplayUpdated() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.isDisplayUpdated();
        }
        return true;
    }

    protected void setDisplayUpdated(boolean bUpdated) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.setDisplayUpdated(bUpdated);
        }
    }

    protected void setSelectionChanged(int flag) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.setSelectionChanged(flag);
        }
    }

    protected void propagateSelectionChanged(int flag) {
        if (this.m_tabs != null) {
            for (int i = 0; i < this.m_tabs.size(); ++i) {
                Object object = this.m_tabs.elementAt(i);
                if (object == null || !(object instanceof VWStepPropTabPanel)) continue;
                ((VWStepPropTabPanel)object).setSelectionChanged(flag);
            }
        }
    }

    boolean isSelectionChanged() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.isSelectionChanged();
        }
        return false;
    }

    protected int getSelectionChanged() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectionChanged();
        }
        return 0;
    }

    public void init() {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.init();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.itemStateChanged(e);
        }
    }

    public int getSelectedOccurrenceIndex() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectedOccurrenceIndex();
        }
        return -1;
    }

    public VWTrkStepOccurrence getSelectedOccurrence() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectedOccurrence();
        }
        return null;
    }

    public VWTrkParticipant getSelectedParticipant() {
        return this.m_selectedParticipant;
    }

    public Object[] getSelectedObjects() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectedObjects();
        }
        return null;
    }

    public ImageIcon getLockedStatusIcon() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getLockedStatusIcon();
        }
        return null;
    }

    protected void clearAllData() {
        this.m_instructions = "";
    }

    protected void clearAllControls() {
    }

    public Vector getItemsChanged() {
        if (!this.isTrackerDataInitialized()) {
            return null;
        }
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        steps.addElement(this.getSelectedStep());
        return steps;
    }

    protected Vector getSteps() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSteps();
        }
        return null;
    }

    protected Vector getSelectedSteps() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectedSteps();
        }
        return null;
    }

    protected VWStepDefinition getStepDefinition() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getStepDefinition();
        }
        return null;
    }

    protected VWTrkStep getSelectedStep() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.getSelectedStep();
        }
        return null;
    }

    protected void setSelectedStep(VWTrkStep step) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.setSelectedStep(step);
        }
    }

    protected void updateSelectedTabNow() {
        Component component;
        if (this.m_bLayoutInitialized && this.isTrackerDataInitialized() && (component = this.m_stepTabbedPane.getSelectedComponent()) != null && component instanceof VWStepPropTabPanel) {
            VWStepPropTabPanel panel = (VWStepPropTabPanel)component;
            try {
                panel.init();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    protected void updateTabs() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        try {
            VWTrkStepOccurrence selectedOccurrence = this.getSelectedOccurrence();
            Object obj = null;
            for (int i = 0; i < this.m_tabs.size(); ++i) {
                obj = this.m_tabs.elementAt(i);
                if (obj == null || !(obj instanceof VWStepPropTabPanel)) continue;
                ((VWStepPropTabPanel)obj).setSelection();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabPane;
        Component component;
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.isUpdating()) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof JTabbedPane && (component = (tabPane = (JTabbedPane)source).getSelectedComponent()) instanceof VWStepPropTabPanel) {
            VWStepPropTabPanel panel = (VWStepPropTabPanel)component;
            try {
                panel.init();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.addItemListener(l);
        }
    }

    public synchronized void removeItemListener(ItemListener l) {
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.removeItemListener(l);
        }
    }

    protected void notifySelectListeners() {
        ItemEvent event = new ItemEvent(this, 0, this, 1);
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.notifySelectListeners(event);
        }
    }

    protected boolean isRuntimeStep() {
        if (this.m_stepPropPanel != null) {
            return this.m_stepPropPanel.isRuntimeStep();
        }
        return false;
    }

    protected boolean isStepView() {
        return this.m_bStepView;
    }

    VWTrkDataModel getDataModel() {
        return this.m_trackerDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            return this.m_updatingCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            ++this.m_updatingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doneUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            if (this.m_updatingCount > 0) {
                --this.m_updatingCount;
            }
        }
    }

    protected boolean getAreRulesEnabled() {
        return this.m_rulesEnabled;
    }

    private void getRulesSystemFlag() {
        try {
            VWSession serviceSession = VWDefaultSessionProxy.getSession();
            if (serviceSession != null) {
                this.m_rulesEnabled = serviceSession.checkSystemWideFlagSetting(1024);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        this.m_stepPropPanel = null;
        this.m_parentFrame = null;
        this.m_selectedParticipant = null;
        if (this.m_tabs != null) {
            this.m_tabs.removeAllElements();
            this.m_tabs = null;
        }
        if (this.m_stepTabbedPane != null) {
            this.m_stepTabbedPane.removeChangeListener(this);
            this.m_stepTabbedPane.removeAll();
            this.m_stepTabbedPane = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeReferences();
            this.m_generalPanel = null;
        }
        if (this.m_routingPanel != null) {
            this.m_routingPanel.removeReferences();
            this.m_routingPanel = null;
        }
        if (this.m_rulesPanel != null) {
            this.m_rulesPanel.removeReferences();
            this.m_rulesPanel = null;
        }
        this.m_stepAndParticipantRenderer = null;
        this.m_instructionsUI = null;
        if (this.m_instructionBorder != null) {
            this.m_instructionBorder.removeReferences();
            this.m_instructionBorder = null;
        }
        this.m_countSync = null;
    }
}

